package org.kurento.room.endpoint;
import org.kurento.client.AlphaBlending;
import org.kurento.client.HubPort;
import org.kurento.client.MediaPipeline;
import org.kurento.client.MediaType;
import org.kurento.room.api.MutedMediaType;
import org.kurento.room.exception.RoomException;
import org.kurento.room.exception.RoomException.Code;
import org.kurento.room.internal.Participant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Subscriber aspect of the {@link MediaEndpoint}.
 *
 * @author <a href="mailto:rvlad@naevatec.com">Radu Tom Vlad</a>
 */
public class SubscriberEndpoint extends MediaEndpoint {
	private final static Logger log = LoggerFactory.getLogger(SubscriberEndpoint.class);

	private boolean connectedToPublisher = false;

	private PublisherEndpoint publisher = null;

	public SubscriberEndpoint(boolean web, Participant owner, String endpointName, MediaPipeline pipeline) {
		super(web, owner, endpointName, pipeline, log);
	}

	/**
	 * 订阅节点
	 * @param sdpOffer	订阅者的sdpOffer
	 * @param publisher 被订阅者的PublisherEndpoint
	 * @param rateLevel 流的级别
	 */
	public synchronized String subscribe(String sdpOffer, PublisherEndpoint publisher, Integer rateLevel) {
		registerOnIceCandidateEventListener();
		String sdpAnswer = processOffer(sdpOffer);
		gatherCandidates();

	    if(rateLevel == 1){
	    	HubPort lowHubPort = publisher.getVideoLowHubPort();
	    	if(lowHubPort == null){
	    		lowHubPort =  new HubPort.Builder(publisher.getVideoBitRate()).build();//出口hubport
	    		publisher.connect(publisher.getVideoEntryHubPort());//将webrtcendpoint连接到入口hubport
	    		lowHubPort.setOutputBitrate(1024*128);//设置出口hubport输出的比特率
	    		publisher.setVideoLowHubPort(lowHubPort);
	    	}
	    	lowHubPort.connect(this.getEndpoint());
	    }else if(rateLevel == 2){
	    	HubPort middleHubPort = publisher.getVideoMiddleHubPort();
	    	if(middleHubPort == null){
	    		middleHubPort =  new HubPort.Builder(publisher.getVideoBitRate()).build();//出口hubport
	    		publisher.connect(publisher.getVideoEntryHubPort());//将webrtcendpoint连接到入口hubport
	    		middleHubPort.setOutputBitrate(1024*512);//设置出口hubport输出的比特率
	    		publisher.setVideoMiddleHubPort(middleHubPort);
	    	}
	    	middleHubPort.connect(this.getEndpoint());
	    }else if(rateLevel == 3){
	    	HubPort highHubPort = publisher.getVideoHighHubPort();
	    	if(highHubPort == null){
	    		highHubPort =  new HubPort.Builder(publisher.getVideoBitRate()).build();//出口hubport
	    		publisher.connect(publisher.getVideoEntryHubPort());//将webrtcendpoint连接到入口hubport
	    		highHubPort.setOutputBitrate(1024*512);//设置出口hubport输出的比特率
	    		publisher.setVideoHighHubPort(highHubPort);
	    	}
	    	highHubPort.connect(this.getEndpoint());
	    }else{
	    	publisher.connect(this.getEndpoint());//原始的
	    }
	    
//		测试将码率
//		Composite Composite = new Composite.Builder(pipeline).build();
//		HubPort hubPort1 = new HubPort.Builder(Composite).build();//入口hubport
//		HubPort hubPort2 =  new HubPort.Builder(Composite).build();//出口hubport
//		publisher.connect(hubPort1);//将webrtcendpoint连接到入口hubport
//		hubPort2.setOutputBitrate(1024*128);//设置出口hubport输出的比特率
//		hubPort2.connect(this.getEndpoint());
    
//		publisher.connect(this.getEndpoint());//原始的
    
		setConnectedToPublisher(true);
		setPublisher(publisher);
		return sdpAnswer;
	}

	/**
	 * 订阅合屏视频流（把流合成到第一个用户的身上）
	 */
	public synchronized String subscribeBach(String sdpOffer, PublisherEndpoint publisher1, PublisherEndpoint publisher2, Integer rateLevel) {
		registerOnIceCandidateEventListener();
		String sdpAnswer = processOffer(sdpOffer);
		gatherCandidates();
		
		//合屏操作
		AlphaBlending alphaBlending = new AlphaBlending.Builder(publisher1.getPipeline()).build();//新建合屏元件
		
		HubPort hubPort_push = new HubPort.Builder(alphaBlending).build();//
		HubPort hubPort1 = new HubPort.Builder(alphaBlending).build();
		HubPort hubPort2 = new HubPort.Builder(alphaBlending).build();
    	alphaBlending.setPortProperties(0, 0, 2, 0.5F, 1, hubPort1);
    	alphaBlending.setPortProperties(0.5F, 0, 3, 1, 1, hubPort2);
    	alphaBlending.setMaster(hubPort_push, 1);
    	publisher1.connect(hubPort1);
    	publisher2.connect(hubPort2);
		
		hubPort_push.connect(this.getEndpoint());
		
		setConnectedToPublisher(true);
		setPublisher(publisher);
		return sdpAnswer;
	}
	
	public boolean isConnectedToPublisher() {
		return connectedToPublisher;
	}

	public void setConnectedToPublisher(boolean connectedToPublisher) {
		this.connectedToPublisher = connectedToPublisher;
	}

	public PublisherEndpoint getPublisher() {
		return publisher;
	}

	public void setPublisher(PublisherEndpoint publisher) {
		this.publisher = publisher;
	}

	@Override
	public synchronized void mute(MutedMediaType muteType) {
		if (this.publisher == null) {
			throw new RoomException(Code.MEDIA_MUTE_ERROR_CODE, "Publisher endpoint not found");
		}
		switch (muteType) {
			case ALL :
				this.publisher.disconnectFrom(this.getEndpoint());
				break;
			case AUDIO :
				this.publisher.disconnectFrom(this.getEndpoint(), MediaType.AUDIO);
				break;
			case VIDEO :
				this.publisher.disconnectFrom(this.getEndpoint(), MediaType.VIDEO);
				break;
		}
		resolveCurrentMuteType(muteType);
	}

	@Override
	public synchronized void unmute() {
		this.publisher.connect(this.getEndpoint());
		setMuteType(null);
	}
}