package org.kurento.room.rpc;

/**
 * Participant information that should be stored in the WebSocket session.
 */
public class ParticipantSession {
	public static final String SESSION_KEY = "participant";

	private String participantName;
	private String roomName;
	private String userId;

	public ParticipantSession() {}

	public ParticipantSession(String participantName, String roomName) {
		super();
		this.participantName = participantName;
		this.roomName = roomName;
	}

	public String getParticipantName() {
		return participantName;
	}

	public void setParticipantName(String participantName) {
		this.participantName = participantName;
	}

	public String getRoomName() {
		return roomName;
	}

	public void setRoomName(String roomName) {
		this.roomName = roomName;
	}

	public String getUserId() {
		return userId;
	}

	public void setUserId(String userId) {
		this.userId = userId;
	}

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[");
		if (participantName != null) {
			builder.append("participantName=").append(participantName).append(", ");
		}
		if (roomName != null) {
			builder.append("roomName=").append(roomName);
		}
		builder.append("]");
		return builder.toString();
	}
}