package org.kurento.room.ttroomserver;

import org.kurento.room.ttroomserver.ServerProvider;
import org.kurento.room.ttroomserver.AliServerProvider;
import org.kurento.room.ttroomserver.LocalServerProvider;

/*
 * used for create provider instance
 */
enum ProviderType{
	REMOTE_ALI,
	LOCAL_CONFIG,
	//TODO: other server provider
}

public class ServerProviderFactory {
	
	public static ServerProvider CreateServerProvider(ProviderType type){
		ServerProvider provider = null;
		if(ProviderType.LOCAL_CONFIG == type){
			//由于配置文件里配置了local所有永远都走这里
			provider = new LocalServerProvider();
		}
		else if(ProviderType.REMOTE_ALI == type){
			provider = new AliServerProvider();
		}
		
		//TODO..other server type
		
		return provider;
	}

}
