package org.kurento.room.ttroomserver;

import org.kurento.room.NotificationRoomManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * Rest controller for the room demo app.
 *
 * @author Radu Tom Vlad (rvlad@naevatec.com)
 * @since 6.0.0
 */
@RestController
public class KmsManagerController {
	  @Autowired
	  private NotificationRoomManager roomManager;
  

		  @RequestMapping("/deleteKms")
		  public void deleteKms(String id) {
		   System.out.println("........................"+id);
		  }
		  
		  
		  @RequestMapping("/closeRoom")
		  public void closeRoom(String id) {
		   System.out.println("........................"+id);
		  }
		  
		  @RequestMapping("/closePerson")
		  public void closePerson(String id) {
			  roomManager.evictParticipant(id);
		   System.out.println("........................"+id);
		  }
		  
		  @RequestMapping("/roomList")
		  public void roomList(String id) {
		   System.out.println("........................"+id);
		  }
		  
}
