package org.kurento.room.ttroomserver;
import org.kurento.commons.ConfigFileManager;
import org.kurento.commons.PropertiesManager;
import org.kurento.room.KurentoRoomServerApp;
import org.kurento.room.api.KurentoClientProvider;
import org.kurento.room.demo.DemoJsonRpcUserControl;
import org.kurento.room.rpc.JsonRpcUserControl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;

import com.google.gson.JsonObject;

@SpringBootApplication(exclude = TTKurentoRoomApp.class)
public class TTKurentoRoomApp extends KurentoRoomServerApp {
	
	private static final Logger log = LoggerFactory.getLogger(TTKurentoRoomApp.class);

	public final static String KROOMDEMO_CFG_FILENAME = "kurento-room-demo.conf.json";

	private static JsonObject DEFAULT_HAT_COORDS = new JsonObject();

	static {
		ConfigFileManager.loadConfigFile(KROOMDEMO_CFG_FILENAME);
	    DEFAULT_HAT_COORDS.addProperty("offsetXPercent", -0.35F);
	    DEFAULT_HAT_COORDS.addProperty("offsetYPercent", -1.2F);
	    DEFAULT_HAT_COORDS.addProperty("widthPercent", 1.6F);
	    DEFAULT_HAT_COORDS.addProperty("heightPercent", 1.6F);
	}

	private static final String IMG_FOLDER = "img/";

	private final String DEFAULT_APP_SERVER_URL = PropertiesManager.getProperty("app.uri", "https://localhost:8443");
 
	private final Integer DEMO_KMS_NODE_LIMIT = PropertiesManager.getProperty("demo.kmsLimit", 1000);
	private final String DEMO_AUTH_REGEX = PropertiesManager.getProperty("demo.authRegex");
	private final String DEMO_HAT_URL = PropertiesManager.getProperty("demo.hatUrl", "mario-wings.png");

	private final JsonObject DEMO_HAT_COORDS = PropertiesManager.getPropertyJson("demo.hatCoords", DEFAULT_HAT_COORDS.toString(), JsonObject.class);
	  
	@Override
	public KurentoClientProvider kmsManager(){
		  KurentoClientProvider provider = new TTKmsManager();
		  return provider;
	}
 
	 @Override
	 public JsonRpcUserControl userControl() {
		  DemoJsonRpcUserControl uc = new DemoJsonRpcUserControl(roomManager());
	    String appServerUrl = System.getProperty("app.server.url", DEFAULT_APP_SERVER_URL);
	    String hatUrl;
	    if (appServerUrl.endsWith("/")) {
	    	hatUrl = appServerUrl + IMG_FOLDER + DEMO_HAT_URL;
	    } else {
	    	hatUrl = appServerUrl + "/" + IMG_FOLDER + DEMO_HAT_URL;
	    }
	    uc.setHatUrl(hatUrl);
	    uc.setHatCoords(DEMO_HAT_COORDS);
	    return uc;
	}

	public static void main(String[] args) throws Exception {
	    log.info("Using /dev/urandom for secure random generation");
	    System.setProperty("java.security.egd", "file:/dev/./urandom");
	    SpringApplication.run(TTKurentoRoomApp.class, args);
	    
	}

}
