kurento_room.controller('KmsManagerController',function($scope, $http,$window, ServiceParticipant, ServiceRoom, Fullscreen, LxNotificationService) {
	 $http({
	        method  : 'post',
	        url     : '/kmsList',
	     }).success(function(data) {
	    	  $scope.kmss= data;
	     }).error(function(data,status,headers,config){
	      	alert("加载失败！");
	     });
	 
	 $scope.find = function(kms) {
		    $http({
		        method  : 'post',
		        url     : '/kmsList',
		        params    : {value:kms.value},  // 传递数据作为字符串
		    }).success(function(data) {
		    	$scope.kmss= data;
	      }).error(function(data,status,headers,config){
	      	alert("错误");
	      });
	    }
	     
	 $scope.deleteKms = function(id) {
		    $http({
		        method  : 'post',
		        url     : '/deleteKms',
		        params    : {id:id},  // 传递数据作为字符串
		    }).success(function(data) {
		    	 if(data == -1)
			    	{
			    		 alert("删除失败！");
			    	}
			    	 else
			    	{
			    		$http.get('/kmsList'
		                 ).success(function(data) {
		                	 $scope.kmss= data;
		                     alert("删除成功！");
		                 }).error(function(){
		                 	alert("刷新失败");
		                 });
			    	}
	      }).error(function(data,status,headers,config){
	      	alert("错误");
	      });
	    }
	 
	 $scope.roomDetail = function(id) {
		 var idd=id.id;
		 $window.location.href = '#/roomDetail/'+idd;
	    }
});

/**
 * 这里是查看房间模块
 * @type {[type]}
 */

kurento_room.controller('KmsDetailController', function($scope, $http,$routeParams, $window, ServiceParticipant, ServiceRoom, Fullscreen, LxNotificationService) {
    $http({
        method  : 'post',
        url     : '/kmsDetail',
        params    : {id:$routeParams.id},  
    }).success(function(data) {
            $scope.rooms = data;
    });
    
    $scope.kmsManager = function() {
    	$window.location.href = '#/kmsManager';
    }
    
    $scope.closeRoom= function(id) {
	    $http({
	        method  : 'post',
	        url     : '/closeRoom',
	        params    : {id:id},  // 传递数据作为字符串
	    }).success(function(data) {
	    	$http({
	            method  : 'post',
	            url     : '/kmsDetail',
	            params    : {id:$routeParams.id},  
	        }).success(function(data) {
	                $scope.rooms = data;
	        });
	    	alert("成功");
      }).error(function(data,status,headers,config){
      	alert("错误");
      });
    }
    

    $scope.lookPersons = function(id) {
		 $window.location.href = '#/lookPerson/'+id+"/"+$routeParams.id;
    }
    

});


/**
 * 这里是查看房间中的人
 * @type {[type]}
 */

kurento_room.controller('PersonDetailController', function($scope,$http,$routeParams, $window, ServiceParticipant, ServiceRoom, Fullscreen, LxNotificationService) {
	 $http({
	        method  : 'post',
	        url     : '/personDetail',
	        params    : {id:$routeParams.id,serverId:$routeParams.serverId},  
	    }).success(function(data) {
	            $scope.users = data;
	    });
	 
	 $scope.back= function() {
		 $window.location.href = '#/roomDetail/'+$routeParams.serverId;
	    }
	 
	 
	 $scope.closePerson= function(id) {
		    $http({
		        method  : 'post',
		        url     : '/closePerson',
		        params    : {id:id},  // 传递数据作为字符串
		    }).success(function(data) {
		    	$http({
			        method  : 'post',
			        url     : '/personDetail',
			        params    : {id:$routeParams.id,serverId:$routeParams.serverId},  
			    }).success(function(data) {
			            $scope.users = data;
			    });
			 
		    	alert("成功");
	      }).error(function(data,status,headers,config){
	      	alert("错误");
	      });
	    }
});
