package org.kurento.room.internal;
import org.kurento.room.api.KurentoClientSessionInfo;

/**
 * Default implementation of the session info interface, contains a
 * participant's id and the room's name.
 *
 * @author <a href="mailto:rvlad@naevatec.com">Radu Tom Vlad</a>
 */
public class DefaultKurentoClientSessionInfo implements KurentoClientSessionInfo {

	private String participantId;
	private String roomName;
	private String needRecorde;

	public String isNeedRecorde() {
		return needRecorde;
	}

	public void setNeedRecorde(String needRecorde) {
		this.needRecorde = needRecorde;
	}

	public DefaultKurentoClientSessionInfo(String participantId, String roomName) {
		super();
		this.participantId = participantId;
		this.roomName = roomName;
	}

	public DefaultKurentoClientSessionInfo(String participantId, String roomName, String needRecorde) {
		super();
		this.participantId = participantId;
		this.roomName = roomName;
		this.needRecorde = needRecorde;
	}

	public String getParticipantId() {
		return participantId;
	}

	public void setParticipantId(String participantId) {
		this.participantId = participantId;
	}

	@Override
	public String getRoomName() {
		return roomName;
	}

	public void setRoomName(String roomName) {
		this.roomName = roomName;
	}
}
