package org.kurento.room.ttroomserver;

/*
 * provide kurento media servers interface
 */

enum ErrorCode{
	ERROR_NONE,
	USER_NAME_INCORRECT,
	USER_PASS_INCORRECT,
	//TODO..other error code
}

enum ServerType{
	TYPE_LOCAL,
	TYPE_REMOTE,
}

public interface ServerProvider {

	/*
	 * some servers need authorize so need user name and user pass
	 */
	public void SetUser(String sUser);
	public void SetPasswd(String sUserPwd);
	public void SetUrl(String sUrl);

	/*
	 * @return: maybe has many return parameters all of them in string
	 */
	public String CreateNewServer();
	public boolean OpenServer(String sServerKey);
	public String GetServerStatus(String sServerKey);
	public boolean CloseServer(String sServerKey);
	public boolean DeleteServer(String sServerKey);
	
	/*
	 * get the server is already running in the server no need wait for its start..
	 */
	public String GetExistServer();
	
	/*
	 * if error occurs can get the error code from this interface
	 */
	public ErrorCode GetLastError();
	
	/*
	 * get the server flag
	 */
	public String GetServerKey();
	
	/*
	 * get the server ip
	 */
	public String GetServerIP();
	
	/*
	 * get the server name
	 */
	public String GetServerName();
	
	/*
	 * provider type 
	 */
	public ServerType GetServerType();
	
}

