package org.kurento.room.internal;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import org.apache.commons.codec.Charsets;
import org.apache.http.Header;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HTTP;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.util.EntityUtils;

/**
 * HTTPS的处理
 * @author cqchen 2016年10月31日17:32:09
 */
public class HttpsUtil {
	
    static CloseableHttpClient httpClient = null;
    
    static {
    	RegistryBuilder<ConnectionSocketFactory> registryBuilder = RegistryBuilder.<ConnectionSocketFactory>create();
    	ConnectionSocketFactory plainSF = new PlainConnectionSocketFactory();
    	registryBuilder.register("http", plainSF);
    	
    	try {
    	    KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());  
    	    SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(trustStore, new TrustStrategy(){
				@Override
				public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
					return true;
				}
    	    }).build();
    	    
    	    LayeredConnectionSocketFactory sslSF = new SSLConnectionSocketFactory(sslContext, new HostnameVerifier(){
				@Override
				public boolean verify(String hostname, SSLSession session) {
					return true;
				}
    		});
    	    
    	    registryBuilder.register("https", sslSF);  
    	} catch (KeyStoreException e) {  
    		throw new RuntimeException(e);  
    	} catch (KeyManagementException e) {  
    	    throw new RuntimeException(e);  
    	} catch (NoSuchAlgorithmException e) {  
    	    throw new RuntimeException(e);  
    	}  
    	Registry<ConnectionSocketFactory> registry = registryBuilder.build();  
    	
    	PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(registry);  
    	connManager.setDefaultConnectionConfig(ConnectionConfig.custom().setCharset(Charsets.toCharset("UTF-8")).build());  
    	connManager.setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(100000).build());  
    	httpClient = HttpClients.custom().setConnectionManager(connManager).build();
    }
    
    /**
     * POST请求
     *
     * @param url
     * @param params
     * @param charset
     * @return
     */
    public static String post(String url, Map<String, String> params, String charset) {
        try {
            HttpPost httpPost = new HttpPost(url);
            List<NameValuePair> formParams = buildNameValuePairParams(params);
            UrlEncodedFormEntity uefEntity = new UrlEncodedFormEntity(formParams, charset);
            httpPost.setEntity(uefEntity);
            try (CloseableHttpResponse response = httpClient.execute(httpPost)) {
                return EntityUtils.toString(response.getEntity());
            }
        } catch (Exception e) {
        }
        return null;
    }
    
    public static String post(String url, String requestData, String charset) {
        try {
            HttpPost httpPost = new HttpPost(url);

            StringEntity stringEntity = new StringEntity(requestData, (charset == null ? "UTF-8" : charset) );
            httpPost.setEntity(stringEntity);

            try (CloseableHttpResponse response = httpClient.execute(httpPost)) {
                return EntityUtils.toString(response.getEntity());
            }
        } catch (Exception e) {
        }
        return null;
    }
    
    /**
     * POST请求
     *
     * @param url
     * @param params
     * @param headerList
     * @param charset
     * @return
     */
    public static String post(String url, List<Header> headerList, Map<String, String> params, String charset) {
        try {
            HttpPost httpPost = new HttpPost(url);
            List<NameValuePair> formParams = buildNameValuePairParams(params);
            UrlEncodedFormEntity uefEntity = new UrlEncodedFormEntity(formParams, charset);
            httpPost.setEntity(uefEntity);
            if (headerList != null) {
                for (Header header : headerList) {
                    httpPost.addHeader(header);
                }
            }
            try (CloseableHttpResponse response = httpClient.execute(httpPost)) {
                return EntityUtils.toString(response.getEntity());
            }
        } catch (Exception e) {
        }
        return null;
    }
    
    private static List<NameValuePair> buildNameValuePairParams(Map<String, String> params) {
        List<NameValuePair> nameValuePairParams = new ArrayList<NameValuePair>();
        if (null != params && !params.isEmpty()) {
            Iterator<Map.Entry<String, String>> iter = params.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<String, String> entry = iter.next();
                nameValuePairParams.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
        }
        return nameValuePairParams;
    }
    
    /**
     * 直接将内容放到post里面
     * @param url
     * @param contentStr
     * @param charset
     * @return
     */
    public static String postWcContent(String url, String contentStr, String charset) {
        try {
            HttpPost httpPost = new HttpPost(url);
            httpPost.setHeader(HTTP.CONTENT_TYPE, "application/json;UTF-8");
            StringEntity stringEntity = new StringEntity(contentStr, charset);

            httpPost.setEntity(stringEntity);

            try (CloseableHttpResponse response = httpClient.execute(httpPost)) {
                return EntityUtils.toString(response.getEntity());
            }
        } catch (Exception e) {
        }
        return null;
    }
    
    public static void main(String[] args) {
    	HttpsUtil.post("https://m.wanyipa.cn/gtopen/cncb/liverecord?message_type=ws_record_finish", "eyJpdGVtcyI6W3sicGVyc2lzdGVudElkIjoiMjAzMjY2NjE1M2ZjYzc4MDRiMzE5MDQ3ODk2YTBkMjE5M2EyIiwic3RyZWFtbmFtZSI6ImxpdmUtRzEwMzYxOV9ub25lXzE1MDQ3ODA3MTczMzguZmx2Iiwib3BzIjoid3NyZWNvcmQvbXA0L3Zjb2RlYy9jb3B5L2Fjb2RlYy9jb3B5fHNhdmVhcy9kWEF0ZDJGdWVXbHdZUzFqYmpva0tITjBjbVZoYlc1aGJXVXBMU1FvZEdsdFpYTjBZVzF3S1E9PSIsImJ1Y2tldCI6InVwLXdhbnlpcGEtY24iLCJjb2RlIjoxLCJkZXNjIjoiZmlsZU9wZXJhdGVBY3RpdmUiLCJlcnJvciI6bnVsbCwia2V5cyI6WyJ1cC13YW55aXBhLWNuOmxpdmUtRzEwMzYxOV9ub25lXzE1MDQ3ODA3MTczMzgtLTIwMTcwOTA3MTgzOTMxLm1wNCJdLCJ1cmxzIjpbImh0dHA6Ly9wYnVwLndhbnlpcGEuY24vbGl2ZS1HMTAzNjE5X25vbmVfMTUwNDc4MDcxNzMzOC0tMjAxNzA5MDcxODM5MzEubXA0Il0sImRldGFpbCI6W3sia2V5IjoidXAtd2FueWlwYS1jbjpsaXZlLUcxMDM2MTlfbm9uZV8xNTA0NzgwNzE3MzM4LS0yMDE3MDkwNzE4MzkzMS5tcDQiLCJ1cmwiOiJodHRwOi8vcGJ1cC53YW55aXBhLmNuL2xpdmUtRzEwMzYxOV9ub25lXzE1MDQ3ODA3MTczMzgtLTIwMTcwOTA3MTgzOTMxLm1wNCIsImR1cmF0aW9uIjo0MjkuMDYzLCJoYXNoIjoibHFMY3BUU1BZZHRaaVZLTkU4Y0pqemFHOS1WMiIsImZzaXplIjoxNTE0NTUxOSwic3RhcnRUaW1lIjoiMjAxNzA5MDcxODM5MzEiLCJlbmRUaW1lIjoiMjAxNzA5MDcxODQ3MTMiLCJiaXRfcmF0ZSI6IjI4MjM5MiIsInJlc29sdXRpb24iOiIzODRYMjU2In1dfV0sImJhdGNoX25vdGlmeV9pZCI6bnVsbH0=", "UTF-8");
	}
}
