package org.kurento.room.internal;

/**
 * This class defines constant values of client-server messages and their parameters.
 * @author <a href="mailto:rvlad@naevatec.com">Radu Tom Vlad</a>
 */
public class ProtocolElements {
	public static final String JOINROOM_METHOD = "joinRoom";
	public static final String PUBLISHVIDEO_METHOD = "publishVideo";
	public static final String SENDMESSAGE_ROOM_METHOD = "sendMessage";
	public static final String LEAVEROOM_METHOD = "leaveRoom";
	public static final String RECORDVIDEO_METHOD = "recordVideo";
	public static final String RECORDSTOP_METHOD = "stopRecordVideo";
	public static final String UNPUBLISHVIDEO_METHOD = "unpublishVideo";
	public static final String RECEIVEVIDEO_METHOD = "receiveVideoFrom";
	public static final String VIEWROOMVIDEO_METHOD = "viewRoomVideo";
	public static final String UNSUBSCRIBEFROMVIDEO_METHOD = "unsubscribeFromVideo";
	public static final String ONICECANDIDATE_METHOD = "onIceCandidate";
	public static final String CUSTOMREQUEST_METHOD = "customRequest";
	public static final String PARTICIPANTJOINED_METHOD = "participantJoined";
	public static final String PARTICIPANTLEFT_METHOD = "participantLeft";
	public static final String PARTICIPANTEVICTED_METHOD = "participantEvicted";
	public static final String PARTICIPANTPUBLISHED_METHOD = "participantPublished";
	public static final String PARTICIPANTUNPUBLISHED_METHOD = "participantUnpublished";
	public static final String PARTICIPANTSENDMESSAGE_METHOD = "sendMessage";
	public static final String ROOMCLOSED_METHOD = "roomClosed";
	public static final String MEDIAERROR_METHOD = "mediaError";
	public static final String ICECANDIDATE_METHOD = "iceCandidate";
	public static final String TEACHER_GOING_GROUP_METHOD = "teacherGoingGroup";
	public static final String CREATE_METTING_GROUP_METHOD = "createMettingGroup";
	public static final String DISSOLUTION_METTING_GROUP_METHOD = "dissolutionMettingGroup";
	public static final String DEL_METTING_GROUP_METHOD = "delMettingGroup";
	public static final String ROLL_CALL_METHOD = "rollCall";
	public static final String SET_PEOPLE_VIDEO_STATUS_METHOD = "setPeopleVideoStatus";
	public static final String SIT_DOWN_METHOD = "sitDown";
	public static final String TOGGLE_SOMEONE_AUDIO_METHOD = "toggleSomeoneAudio";
	public static final String ALLOW_OPERATE_METHOD = "allowOperate";
	public static final String RAISE_HANDS_METHOD = "raiseHands";
	public static final String SEND_ANSWER_METHOD = "sendAnswer";
	public static final String DISBAND_ROOM_METHOD = "disbandRoom";
	public static final String UPDATE_ROOM_STATUS_METHOD = "updateRoomStatus";
	public static final String SEND_QUESTION_METHOD = "sendQuestion";
	public static final String SEND_ANSWER_QUESTION_RESULT_METHOD = "sendAnswerQuestionResult";
	public static final String CLOSE_ANSWER_SHEET_METHOD = "closeAnswerSheet"; 
	public static final String TOGGLE_SOMEONE_VIDEO_METHOD = "toggleSomeoneVideo";
	public static final String ONE_KEY_OPERATION_METHOD = "oneKeyOperation";

	public static final String SENDMESSAGE_USER_PARAM = "userMessage";
	public static final String SENDMESSAGE_ROOM_PARAM = "roomMessage";
	public static final String SENDMESSAGE_MESSAGE_PARAM = "message";
	public static final boolean RECORD_ROOM_PARAM = false;
	public static final String JOINROOM_USER_PARAM = "user";
	public static final String JOINROOM_ROOM_PARAM = "room";
	public static final String JOINROOM_PEERID_PARAM = "id";
	public static final String JOINROOM_PEERSTREAMS_PARAM = "streams";
	public static final String JOINROOM_PEERSTREAMID_PARAM = "id";
	public static final String PUBLISHVIDEO_SDPOFFER_PARAM = "sdpOffer";
	public static final String PUBLISHVIDEO_DOLOOPBACK_PARAM = "doLoopback";
	public static final String PUBLISHVIDEO_SDPANSWER_PARAM = "sdpAnswer";
	public static final String RECEIVEVIDEO_SDPOFFER_PARAM = "sdpOffer";
	public static final String RECEIVEVIDEO_SENDER_PARAM = "sender";
	public static final String RECEIVEVIDEO_SDPANSWER_PARAM = "sdpAnswer";
	public static final String VIEWROOMVIDEO_SDPOFFER_PARAM = "sdpOffer";
	public static final String VIEWROOMVIDEO_SENDER_PARAM = "sender";
	public static final String VIEWROOMVIDEO_SDPANSWER_PARAM = "sdpAnswer";
	public static final String UNSUBSCRIBEFROMVIDEO_SENDER_PARAM = "sender";
	public static final String ROLL_CALL_RESULT = "result";
	public static final String ROLL_CALL_USER = "rollCallUser";
	public static final String SIT_DOWN_USER = "sitDownUser";
	public static final String SIT_DOWN_RESULT = "result";
	public static final String ONICECANDIDATE_EPNAME_PARAM = "endpointName";
	public static final String ONICECANDIDATE_CANDIDATE_PARAM = "candidate";
	public static final String ONICECANDIDATE_SDPMIDPARAM = "sdpMid";
	public static final String ONICECANDIDATE_SDPMLINEINDEX_PARAM = "sdpMLineIndex";
	public static final String PARTICIPANTJOINED_USER_PARAM = "id";
	public static final String PARTICIPANTJOINED_USER_ROLE = "role";
	public static final String PARTICIPANTLEFT_NAME_PARAM = "name";
	public static final String PARTICIPANTPUBLISHED_USER_PARAM = "id";
	public static final String PARTICIPANTPUBLISHED_STREAMS_PARAM = "streams";
	public static final String PARTICIPANTPUBLISHED_STREAMID_PARAM = "id";
	public static final String PARTICIPANTPUBLISHED_USER_ROLE = "role";
	public static final String PARTICIPANTUNPUBLISHED_NAME_PARAM = "name";
	public static final String PARTICIPANTSENDMESSAGE_USER_PARAM = "user";
	public static final String PARTICIPANTSENDMESSAGE_ROOM_PARAM = "room";
	public static final String PARTICIPANTSENDMESSAGE_MESSAGE_PARAM = "message";
	public static final String ROOMCLOSED_ROOM_PARAM = "room";
	public static final String MEDIAERROR_ERROR_PARAM = "error";
	public static final String ICECANDIDATE_EPNAME_PARAM = "endpointName";
	public static final String ICECANDIDATE_CANDIDATE_PARAM = "candidate";
	public static final String ICECANDIDATE_SDPMID_PARAM = "sdpMid";
	public static final String ICECANDIDATE_SDPMLINEINDEX_PARAM = "sdpMLineIndex";
	public static final String ROOM_ID = "roomId";
	public static final String CLASS_ID = "classId";
	public static final String CLASS_METTING_ID = "classMettingId";
	public static final String CM_NAME = "cmName";
	public static final String NUMBER = "number";
	public static final String GROUP_INFO = "groupInfo";
	public static final String STATUS = "status";
	public static final String LAYOUT_ROOM_STATUS = "layoutRoomStatus";
	public static final String BROADCAST = "broadcast";
	public static final String USER_ID = "userId";
	public static final String VIDEO_STATUS = "videoStatus";
	public static final String TEACHER_IN_GROUPID = "teacherInGroupId";
	public static final String GROUP_ID = "groupId";
	public static final String SEND_GROUP_NOTICE = "sendGroupNotice";
}
